<?php

namespace App\Http\Controllers;

use App\Models\Apishowroom;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Http;

class CentralCheckReportController extends Controller
{
    public function index(Request $request)
    {
        $selectedMonth = $request->input('month', Carbon::now()->format('Y-m'));
        $showrooms = Apishowroom::where('is_active', true)->get();
        $allReports = [];
        $errors = [];

        foreach ($showrooms as $showroom) {
            $response = Http::withToken($showroom->api_token)->get($showroom->api_url . '/monthly-report', [
                'month' => $selectedMonth,
            ]);

            if ($response->successful()) {
                $reportData = $response->json();
                $allReports[] = [
                    'showroom_name' => $showroom->name,
                    'showroom_identifier' => $showroom->identifier,
                    'selected_month' => $reportData['selected_month'],
                    'daily_data' => $reportData['daily_data'],
                    'monthly_totals' => $reportData['monthly_totals'],
                ];

                // Update last_pulled_at
                $showroom->update(['last_pulled_at' => Carbon::now()]);
            } else {
                $errors[] = "Failed to fetch report from {$showroom->name} ({$showroom->identifier}).";
            }
        }

        return view('reports.monthly_summary', [
            'selectedMonth' => $selectedMonth,
            'allReports' => $allReports,
            'errors' => $errors,
        ]);
    }


}