<?php

namespace App\Http\Controllers;

use App\Models\Apishowroom;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Http;

class CentralDrinksCheckController extends Controller
{
    public function index(Request $request)
    {
        $year = (int)$request->input('year', Carbon::now()->year);
        $month = (int)$request->input('month', Carbon::now()->month);

        // Fetch unique years from Showrooms
        $showrooms = Apishowroom::where('is_active', true)->get();
        $years = collect([Carbon::now()->year]);
        foreach ($showrooms as $showroom) {
            $response = Http::withToken($showroom->api_token)->get($showroom->api_url . '/drinks-report-years');
            if ($response->successful()) {
                $years = $years->merge($response->json())->unique();
            }
        }
        $years = $years->sortDesc()->values();

        $allReports = [];
        $errors = [];

        foreach ($showrooms as $showroom) {
            $response = Http::withToken($showroom->api_token)->get($showroom->api_url . '/drinks-report', [
                'year' => $year,
                'month' => $month,
            ]);

            if ($response->successful()) {
                $reportData = $response->json();
                $allReports[] = [
                    'showroom_name' => $showroom->name,
                    'showroom_identifier' => $showroom->identifier,
                    'year' => $reportData['year'],
                    'month' => $reportData['month'],
                    'report_data' => $reportData['report_data'],
                    'product_headers' => $reportData['product_headers'],
                    'product_totals' => $reportData['product_totals'],
                    'grand_total' => $reportData['grand_total'],
                ];

                // Update last_pulled_at
                $showroom->update(['last_pulled_at' => Carbon::now()]);
            } else {
                $errors[] = "Failed to fetch drinks report from {$showroom->name} ({$showroom->identifier}).";
            }
        }

        return view('reports.drinksreport', [
            'years' => $years,
            'selectedYear' => $year,
            'selectedMonth' => $month,
            'allReports' => $allReports,
            'errors' => $errors,
        ]);
    }


}