<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CentralSalesReport
 * 
 * @property int $id
 * @property string $sale_code
 * @property Carbon $sale_date
 * @property float $total_price
 * @property float|null $discount_amount
 * @property string|null $customer_name
 * @property string|null $customer_phone
 * @property string $showroom_name
 * @property string $user_name
 * @property string $payment_method
 * @property float $payment_amount
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class CentralSalesReport extends Model
{
	protected $table = 'central_sales_reports';

	protected $casts = [
		'sale_date' => 'datetime',
		'total_price' => 'float',
		'discount_amount' => 'float',
		'payment_amount' => 'float'
	];

	protected $fillable = [
		'sale_code',
		'sale_date',
		'total_price',
		'discount_amount',
		'customer_name',
		'customer_phone',
		'showroom_name',
		'user_name',
		'payment_method',
		'payment_amount'
	];

	    public function saleItems()
    {
        return $this->hasMany(CentralSaleItem::class, 'central_sale_report_id');
    }
	
}
