<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CentralShowroom
 * 
 * @property int $id
 * @property string $name
 * @property string|null $code
 * @property string|null $api_url
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class CentralShowroom extends Model
{
	protected $table = 'central_showrooms';

	protected $fillable = [
		'name',
		'code',
		'api_url'
	];

	    public function centralSalesReports()
    {
        return $this->hasMany(CentralSalesReport::class, 'central_showroom_id');
    }

}
