<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Showroom
 * 
 * @property int $id
 * @property string $name
 * @property string $code
 * @property string|null $address
 * @property string|null $city
 * @property string|null $state
 * @property string|null $postal_code
 * @property string|null $country
 * @property string|null $phone
 * @property string|null $email
 * @property string|null $manager_name
 * @property string|null $manager_phone
 * @property string|null $manager_email
 * @property string|null $status
 * @property Carbon|null $opening_time
 * @property Carbon|null $closing_time
 * @property string|null $description
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Showroom extends Model
{
	protected $table = 'showrooms';

	protected $casts = [
		'opening_time' => 'datetime',
		'closing_time' => 'datetime'
	];

	protected $fillable = [
		'name',
		'code',
		'address',
		'city',
		'state',
		'postal_code',
		'country',
		'phone',
		'email',
		'manager_name',
		'manager_phone',
		'manager_email',
		'status',
		'opening_time',
		'closing_time',
		'description'
	];

//	// Eloquent relationship to products
	public function products()
	{
		return $this->hasMany(Product::class);
	}

	// Eloquent relationship to stocks
	public function stocks()
	{
		return $this->hasMany(ProductStock::class);
	}



}
