<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
{
    // Create roles
    $adminRole = Role::create(['name' => 'admin']);
    $editorRole = Role::create(['name' => 'editor']);

    // Create permissions
    $createUserPermission = Permission::create(['name' => 'create users']);
    $editUserPermission = Permission::create(['name' => 'edit users']);

    // Assign permissions to roles
    $adminRole->givePermissionTo([$createUserPermission, $editUserPermission]);
    $editorRole->givePermissionTo($editUserPermission);
}
}
