import './bootstrap';

import Alpine from 'alpinejs';

window.Alpine = Alpine;

Alpine.start();

document.addEventListener('DOMContentLoaded', () => {
    const sidebar = document.getElementById('sidebar');
    const toggleSidebar = document.getElementById('toggle-sidebar');
    const mobileToggle = document.getElementById('mobile-toggle');

    // Toggle sidebar for mobile
    mobileToggle.addEventListener('click', () => {
        sidebar.classList.toggle('hidden');
    });

    // Toggle sidebar state for desktop and save to session
    toggleSidebar.addEventListener('click', () => {
        const isCollapsed = sidebar.classList.contains('md:w-16');
        sidebar.classList.toggle('md:w-16', !isCollapsed);
        sidebar.classList.toggle('md:w-64', isCollapsed);

        // Save state to session via AJAX
        fetch('/toggle-sidebar', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            },
            body: JSON.stringify({ collapsed: !isCollapsed }),
        });
    });
});
