@extends('layouts.main')

@section('content')
<div class="container-fluid p-2">
    <h6 class="mb-3">Showroom Management</h6>

    @if(session('success'))
        <div class="alert alert-success py-1 px-2 small">
            {{ session('success') }}
        </div>
    @endif
    
    @if(session('sync_results'))
    <div class="alert alert-info py-1 px-2 small mt-2">
        <strong>Sync Summary:</strong>
        <ul class="mb-0">
            @foreach(session('sync_results') as $res)
                <li>
                    {{ $res['showroom'] }} —
                    <span class="{{ $res['status'] === 'Success' ? 'text-success' : 'text-danger' }}">
                        {{ $res['status'] }}
                    </span>
                    @if(!empty($res['error']))
                        <small class="text-muted">({{ $res['error'] }})</small>
                    @endif
                </li>
            @endforeach
        </ul>
    </div>
@endif

<form method="GET" action="{{ route('admin.sync.dashboard') }}" class="row g-2 mb-3 small">
    <div class="col-auto">
        <input type="date" name="from" class="form-control form-control-sm"
               value="{{ request('from') ?? now()->subDay()->toDateString() }}">
    </div>
    <div class="col-auto">
        <input type="date" name="to" class="form-control form-control-sm"
               value="{{ request('to') ?? now()->toDateString() }}">
    </div>
    <div class="col-auto">
        <button type="submit" class="btn btn-sm btn-outline-primary">Apply</button>
    </div>
</form>


    {{-- Create Form --}}
    <form method="POST" action="{{ route('admin.showrooms.store') }}" class="row g-2 mb-3 small">
        @csrf
        <div class="col-auto">
            <input type="text" name="name" class="form-control form-control-sm" placeholder="Name" required>
        </div>
        <div class="col-auto">
            <input type="text" name="identifier" class="form-control form-control-sm" placeholder="Identifier" required>
        </div>
        <div class="col-auto">
            <input type="url" name="api_url" class="form-control form-control-sm" placeholder="API URL" required>
        </div>
        <div class="col-auto">
            <input type="text" name="api_token" class="form-control form-control-sm" placeholder="API Token">
        </div>
        <div class="col-auto">
            <select name="status" class="form-select form-select-sm select2" required>
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
            </select>
        </div>
        <div class="col-auto">
            <button type="submit" class="btn btn-sm btn-primary">Add</button>
        </div>
        <div class="col-auto">
        <form method="POST" action="{{ route('admin.sync.pull_all_stock') }}">
            @csrf
            <input type="hidden" name="from" value="{{ request('from') ?? now()->subDay()->toDateString() }}">
            <input type="hidden" name="to" value="{{ request('to') ?? now()->toDateString() }}">
            <button type="submit" class="btn btn-sm btn-dark">Sync All</button>
        </form>
    </div>
        <div class="col-auto">
            <button onclick="window.print()" type="button" class="btn btn-sm btn-secondary">Print</button>
            <button onclick="sheetExport()" type="button" class="btn btn-sm btn-success">Export</button>
        </div>
    </form>

    {{-- Showroom Table --}}
    <table class="table table-sm table-bordered table-striped table-hover small" id="showrooms-table">
        <thead class="table-light">
            <tr>
                <th>Name</th>
                <th>Identifier</th>
                <th>Status</th>
                <th>API URL</th>
                <th>Last Pulled</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        @foreach($apishowrooms as $showroom)
            <tr>
                <td>{{ $showroom->name }}</td>
                <td>{{ $showroom->identifier }}</td>
                <td class="text-capitalize">{{ $showroom->is_active ? 'active' : 'inactive' }}</td>
                <td class="text-truncate" style="max-width: 160px;">{{ $showroom->api_url }}</td>
                <td>{{ $showroom->last_pulled_at ?? '-' }}</td>
                <td class="text-nowrap">

                    {{-- Sync Button --}}
                   <form method="POST" action="{{ route('admin.showrooms.pull_stock', $showroom) }}" class="d-inline">
                    @csrf
                    <input type="hidden" name="from" value="{{ request('from') ?? now()->subDay()->toDateString() }}">
                    <input type="hidden" name="to" value="{{ request('to') ?? now()->toDateString() }}">
                    <button type="submit" class="btn btn-sm btn-outline-info">Pull</button>
                </form>

                    {{-- Edit Button --}}

                    {{-- Toggle Button --}}
                    <form method="POST" action="{{ route('admin.showrooms.toggle_status', $showroom) }}" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-sm btn-outline-warning">
                            {{ $showroom->is_active ? 'Deactivate' : 'Activate' }}
                        </button>
                    </form>

                    {{-- Delete Button --}}
                    <form method="POST" action="{{ route('admin.showrooms.destroy', $showroom) }}" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this showroom?')">Del</button>
                    </form>

                </td>
            </tr>
        @endforeach
        </tbody>
    </table>

    <div class="mt-2">
        {{ $apishowrooms->links('pagination::bootstrap-5') }}
    </div>
</div>

{{-- Export Script --}}
<script>
function sheetExport() {
    const table = document.getElementById('showrooms-table');
    const wb = XLSX.utils.table_to_book(table);
    XLSX.writeFile(wb, 'showrooms.xlsx');
}
</script>
@endsection
