@extends('layouts.main')

@section('content')
<div class="container-fluid mt-3">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Discount Campaigns</h5>
        
        <div>
            <form action="{{ route('syncDiscountData.showrooms') }}" method="POST">
                @csrf
                <button type="submit" class="btn btn-sm btn-primary">Sync Data to Showrooms</button>
            </form>
            <a href="{{ route('discount_campaigns.create') }}" class="btn btn-primary btn-sm me-2">Create New Campaign</a>
            <button id="printTable" class="btn btn-info btn-sm me-2">Print Report</button>
            <button id="exportTable" class="btn btn-success btn-sm">Export to Excel</button>
        </div>
    </div>

   @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if (session('warning'))
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            {{ session('warning') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover table-sm" id="discountCampaignsTable">
            <thead class="table-light">
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Campaign Name</th>
                    <th scope="col">Discount Name</th>
                    <th scope="col">Discount Value</th>
                    <th scope="col">Discount Type</th>
                    <th scope="col">Target Type</th>
                    <th scope="col">Target</th>
                    <th scope="col">Start Date</th>
                    <th scope="col">End Date</th>
                    <th scope="col">Active</th>
                    <th scope="col" class="text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($discountCampaigns as $campaign)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $campaign->name }}</td>
                        <td>{{ $campaign->discount->name ?? 'N/A' }}</td>
                        <td>{{ $campaign->discount->value ?? 'N/A' }} {{ ($campaign->discount && $campaign->discount->type == 'percentage') ? '%' : '' }}</td>
                        <td>{{ ucfirst($campaign->discount->type ?? 'N/A') }}</td>
                        <td>{{ ucfirst($campaign->discount_type) }}</td>
                        <td>
                            @if ($campaign->discount_type == 'products')
                                {{-- Access the 'relatedProducts' attribute set by the controller --}}
                                @if ($campaign->relatedProducts->isNotEmpty())
                                    <ul class="list-unstyled mb-0 small">
                                        @foreach ($campaign->relatedProducts as $product)
                                            <li>{{ $product->productname }}</li>
                                        @endforeach
                                    </ul>
                                @else
                                    N/A
                                @endif
                            @elseif ($campaign->discount_type == 'category')
                                {{ $campaign->category_name }}
                            @else
                                Global
                            @endif
                        </td>
                        <td>{{ $campaign->discount->start_date->format('Y-m-d') ?? 'N/A' }}</td>
                        <td>{{ $campaign->discount->end_date->format('Y-m-d') ?? 'N/A' }}</td>
                        <td>
                            <span class="badge {{ $campaign->is_active ? 'bg-success' : 'bg-danger' }}">
                                {{ $campaign->is_active ? 'Yes' : 'No' }}
                            </span>
                        </td>
                        <td class="text-center">
                            <a href="{{ route('discount_campaigns.edit', $campaign->id) }}" class="btn btn-warning btn-sm me-1">Edit</a>
                            <form action="{{ route('discount_campaigns.destroy', $campaign->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this campaign?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="11" class="text-center">No discount campaigns found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-center">
        {{ $discountCampaigns->links('pagination::bootstrap-5') }}
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Print functionality
        document.getElementById('printTable').addEventListener('click', function() {
            printJS({
                printable: 'discountCampaignsTable',
                type: 'html',
                header: '<h3>Discount Campaigns Report</h3>',
                css: 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css',
                style: '@page { size: landscape; } table { width: 100%; border-collapse: collapse; } th, td { border: 1px solid #ddd; padding: 8px; }'
            });
        });

        // Export to Excel functionality
        document.getElementById('exportTable').addEventListener('click', function() {
            let table = document.getElementById('discountCampaignsTable');
            let ws = XLSX.utils.table_to_sheet(table);
            let wb = XLSX.utils.book_new();
            XLSX.utils.book_append_sheet(wb, ws, "Discount Campaigns");
            XLSX.writeFile(wb, "DiscountCampaigns.xlsx");
        });
    });
</script>
@endpush
