@extends('layouts.main')

@section('title', 'Add New Discount')

@section('content')
<div class="container-fluid mt-3">
    <div class="card card-sm">
        <div class="card-header py-2">
            <h5 class="mb-0">Add New Discount</h5>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger alert-sm p-2">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('discounts.store') }}" method="POST">
                @csrf
                @include('discounts._form') {{-- Include the reusable form partial --}}

                <div class="d-flex justify-content-end mt-3">
                    <button type="submit" class="btn btn-primary btn-sm me-2">Save Discount</button>
                    <a href="{{ route('discounts.index') }}" class="btn btn-secondary btn-sm">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection