@extends('layouts.main')

@section('title', 'Discounts List')

@section('content')
<div class="container-fluid mt-3">
    <div class="card card-sm">
        <div class="card-header py-2 d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Discounts</h5>
            <div>
                <a href="{{ route('discounts.create') }}" class="btn btn-success btn-sm me-2">Add New Discount</a>
                <button id="printReportBtn" class="btn btn-info btn-sm me-2">Print Report</button>
                <button id="exportDataBtn" class="btn btn-primary btn-sm">Export Data</button>
            </div>
        </div>
        <div class="card-body p-2">
            @if (session('success'))
                <div class="alert alert-success alert-sm p-2 mb-2">
                    {{ session('success') }}
                </div>
            @endif
            @if (session('error'))
                <div class="alert alert-danger alert-sm p-2 mb-2">
                    {{ session('error') }}
                </div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover table-sm" id="discounts-table"> {{-- Added ID for printing --}}
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Value</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Active</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($discounts as $discount)
                            <tr>
                                <td>{{ $loop->iteration + ($discounts->currentPage() - 1) * $discounts->perPage() }}</td>
                                <td>{{ $discount->name }}</td>
                                <td>{{ ucwords(str_replace('_', ' ', $discount->type)) }}</td>
                                <td>{{ $discount->value }}{{ $discount->type == 'percentage' ? '%' : '' }}</td>
                                <td>{{ $discount->start_date->format('Y-m-d H:i') }}</td>
                                <td>{{ $discount->end_date->format('Y-m-d H:i') }}</td>
                                <td>
                                    @if($discount->is_active)
                                        <span class="badge bg-success">Yes</span>
                                    @else
                                        <span class="badge bg-danger">No</span>
                                    @endif
                                </td>
                                <td class="d-flex">
                                    <a href="{{ route('discounts.edit', $discount->id) }}" class="btn btn-warning btn-sm me-1">Edit</a>
                                    <form action="{{ route('discounts.destroy', $discount->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this discount?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center">No discounts found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-center">
                {{ $discounts->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Print.js integration
    document.getElementById('printReportBtn').addEventListener('click', function() {
        printJS({
            printable: 'discounts-table', // Use the ID of your table
            type: 'html',
            header: '<h2>Discount Report</h2>',
            css: 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css',
            style: `
                /* Custom styles for printing */
                table { width: 100%; border-collapse: collapse; }
                th, td { border: 1px solid #dee2e6; padding: 0.25rem; text-align: left; font-size: 0.75rem; }
                h2 { text-align: center; margin-bottom: 1rem; }
                /* Ensure text is black for printing */
                body, table, th, td { color: #000 !important; }
            `
        });
        console.log('Print report button clicked. (Requires print.js library)');
    });

    // Sheet.js integration for exporting
    document.getElementById('exportDataBtn').addEventListener('click', function() {
        const table = document.getElementById('discounts-table'); // Select the table by ID
        if (table) {
            const ws = XLSX.utils.table_to_sheet(table);
            const wb = XLSX.utils.book_new();
            XLSX.utils.book_append_sheet(wb, ws, "Discounts");
            XLSX.writeFile(wb, "discounts_data.xlsx");
            console.log('Export data button clicked. (Requires sheet.js library)');
        } else {
            console.error('Table not found for export.');
        }
    });
</script>
@endpush