@extends('layouts.main')

@section('content')
<div class="container-fluid small">
    <div class="d-flex justify-content-between mb-2">
        <h6 class="fw-bold">Edit Product</h6>
        <a href="{{ route('products.index') }}" class="btn btn-sm btn-secondary">Back</a>
    </div>

    <form method="POST" action="{{ route('products.update', $product) }}" class="row g-2">
        @csrf @method('PUT')

        <div class="col-md-4">
            <label class="form-label">Date of Entry</label>
            <input type="date" name="dateofentry" class="form-control form-control-sm @error('dateofentry') is-invalid @enderror" value="{{ old('dateofentry', $product->dateofentry ? $product->dateofentry->format('Y-m-d') : '') }}">
            @error('dateofentry') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        <div class="col-md-4">
            <label class="form-label">Product Name</label>
            <input type="text" name="productname" class="form-control form-control-sm @error('productname') is-invalid @enderror" value="{{ old('productname', $product->productname) }}">
            @error('productname') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        <div class="col-md-4">
            <label class="form-label">Department</label>
            <input type="text" name="productiondepartment" class="form-control form-control-sm @error('productiondepartment') is-invalid @enderror" value="{{ old('productiondepartment', $product->productiondepartment) }}">
            @error('productiondepartment') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        <div class="col-md-6">
            <label class="form-label">Category</label>
            <input type="text" name="productcategory" class="form-control form-control-sm @error('productcategory') is-invalid @enderror" value="{{ old('productcategory', $product->productcategory) }}">
            @error('productcategory') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        <div class="col-md-6">
            <label class="form-label">Price</label>
            <input type="number" step="0.01" name="price" class="form-control form-control-sm @error('price') is-invalid @enderror" value="{{ old('price', $product->price) }}">
            @error('price') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        {{-- New Fields Start Here --}}

        <div class="col-md-4">
            <label class="form-label">Barcode</label>
            <input type="text" name="barcode" class="form-control form-control-sm @error('barcode') is-invalid @enderror" value="{{ old('barcode', $product->barcode) }}">
            @error('barcode') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        <div class="col-md-4">
            <label class="form-label">SKU</label>
            <input type="text" name="sku" class="form-control form-control-sm @error('sku') is-invalid @enderror" value="{{ old('sku', $product->sku) }}">
            @error('sku') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        <div class="col-md-4">
            <label class="form-label">Custom No</label>
            <input type="text" name="custom_no" class="form-control form-control-sm @error('custom_no') is-invalid @enderror" value="{{ old('custom_no', $product->custom_no) }}">
            @error('custom_no') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        <div class="col-md-4">
            <label class="form-label">Unit</label>
            <input type="text" name="unit" class="form-control form-control-sm @error('unit') is-invalid @enderror" value="{{ old('unit', $product->unit) }}">
            @error('unit') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        <div class="col-md-4">
            <label class="form-label">Status</label>
            <input type="text" name="status" class="form-control form-control-sm @error('status') is-invalid @enderror" value="{{ old('status', $product->status) }}">
            @error('status') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        <div class="col-md-4">
            <label class="form-label">Showroom</label>
            <select name="showroom_id" class="form-select form-select-sm @error('showroom_id') is-invalid @enderror">
                <option value="">Select Showroom</option>
                @foreach($apishowrooms as $showroom)
                    <option value="{{ $showroom->id }}" {{ old('showroom_id', $product->showroom_id) == $showroom->id ? 'selected' : '' }}>
                        {{ $showroom->name }}
                    </option>
                @endforeach
            </select>
            @error('showroom_id') <div class="text-danger small">{{ $message }}</div> @enderror
        </div>

        {{-- New Fields End Here --}}

        <div class="col-12 text-end">
            <button class="btn btn-sm btn-primary">Update</button>
        </div>
    </form>
</div>
@endsection