@extends('layouts.main')

@section('content')
<div class="container-fluid small">
    <div class="d-flex justify-content-between mb-2">
        <h6 class="fw-bold">Product List</h6>
        <div>
            <a href="{{ route('products.create') }}" class="btn btn-sm btn-primary">Add Product</a>
            <button class="btn btn-sm btn-outline-secondary" onclick="printJS({ printable: 'product-table', type: 'html' })">Print</button>
            <button class="btn btn-sm btn-outline-success" onclick="exportToExcel()">Export</button>
            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#syncProductsModal">
                <i class="fas fa-cloud-upload-alt"></i> Push Products to showroom(s)
            </button>
            <form action="{{ route('products.syncPrices') }}" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to sync product prices from the Products table? This will update existing prices and add new ones for the effective date 2025-06-01.');">
                @csrf {{-- Laravel's CSRF protection --}}
                <button type="submit" class="btn btn-sm btn-info">
                    <i class="fas fa-sync-alt"></i> Send Product Data (internal)
                </button>
            </form>
        </div>
    </div>

    <form method="GET" class="row g-1 mb-2 align-items-end"> {{-- Added align-items-end for better alignment --}}
        <div class="col-auto">
            <label for="search_productname" class="form-label small mb-0">Name/Code:</label>
            <input type="text" id="search_productname" name="search" class="form-control form-control-sm" value="{{ request('search') }}" placeholder="Search by name, barcode, SKU, custom no">
        </div>
        {{-- Individual search fields for more specific filtering --}}
        <div class="col-auto">
            <label for="search_barcode" class="form-label small mb-0">Barcode:</label>
            <input type="text" id="search_barcode" name="barcode" class="form-control form-control-sm" value="{{ request('barcode') }}" placeholder="Barcode">
        </div>
        <div class="col-auto">
            <label for="search_sku" class="form-label small mb-0">SKU:</label>
            <input type="text" id="search_sku" name="sku" class="form-control form-control-sm" value="{{ request('sku') }}" placeholder="SKU">
        </div>
        <div class="col-auto">
            <label for="search_custom_no" class="form-label small mb-0">Custom No:</label>
            <input type="text" id="search_custom_no" name="custom_no" class="form-control form-control-sm" value="{{ request('custom_no') }}" placeholder="Custom No">
        </div>
        <div class="col-auto">
            <label for="search_unit" class="form-label small mb-0">Unit:</label>
            <input type="text" id="search_unit" name="unit" class="form-control form-control-sm" value="{{ request('unit') }}" placeholder="Unit">
        </div>
        <div class="col-auto">
            <label for="search_status" class="form-label small mb-0">Status:</label>
            <input type="text" id="search_status" name="status" class="form-control form-control-sm" value="{{ request('status') }}" placeholder="Status">
        </div>
        <div class="col-auto">
            <label for="search_showroom" class="form-label small mb-0">Showroom:</label>
            <select name="showroom_id" id="search_showroom" class="form-select form-select-sm">
                <option value="">All Showrooms</option>
                @foreach ($apishowrooms as $apishowroom)
                    <option value="{{ $apishowroom->id }}" {{ (string)request('showroom_id') === (string)$apishowroom->id ? 'selected' : '' }}>
                        {{ $apishowroom->name }}
                    </option>
                @endforeach
            </select>
        </div>
        <div class="col-auto">
            <button type="submit" class="btn btn-sm btn-secondary">Filter</button>
            <a href="{{ route('products.index') }}" class="btn btn-sm btn-outline-secondary">Clear</a> {{-- Added Clear button --}}
        </div>
    </form>

    <div class="table-responsive">
        <table class="table table-sm table-bordered table-striped table-hover" id="product-table">
            <thead class="table-light text-center small">
                <tr>
                    <th>ID</th>
                    <th>Date</th>
                    <th>Name</th>
                    <th>Department</th>
                    <th>Category</th>
                    <th>Barcode</th> {{-- New field header --}}
                    <th>SKU</th> {{-- New field header --}}
                    <th>Custom No</th> {{-- New field header --}}
                    <th>Unit</th> {{-- New field header --}}
                    <th>Status</th> {{-- New field header --}}
                    <th>Showroom</th> {{-- New field header --}}
                    <th class="text-end">Price</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody class="small">
                @foreach($products as $i => $p)
                <tr>
                    <td class="text-center">{{ $p->id }}</td>
                    <td>{{ $p->dateofentry->format('Y-m-d') }}</td>
                    <td>{{ $p->productname }}</td>
                    <td>{{ $p->productiondepartment }}</td>
                    <td>{{ $p->productcategory }}</td>
                    <td>{{ $p->barcode }}</td> {{-- Display new field --}}
                    <td>{{ $p->sku }}</td> {{-- Display new field --}}
                    <td>{{ $p->custom_no }}</td> {{-- Display new field --}}
                    <td>{{ $p->unit }}</td> {{-- Display new field --}}
                    <td>{{ $p->status }}</td> {{-- Display new field --}}
                    <td>{{ $p->showroom->name ?? 'N/A' }}</td> {{-- Display showroom name, with N/A fallback --}}
                    <td class="text-end">{{ number_format($p->price, 2) }}</td>
                    <td class="text-nowrap">
                        <a href="{{ route('products.edit', $p) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                        <form action="{{ route('products.destroy', $p) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete?')">
                            @csrf @method('DELETE')
                            <button class="btn btn-sm btn-outline-danger">Del</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        {{-- Sync Products Modal --}}
        <div class="modal fade" id="syncProductsModal" tabindex="-1" aria-labelledby="syncProductsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-sm">
                <div class="modal-content">
                    <div class="modal-header py-2 px-3">
                        <h6 class="modal-title small" id="syncProductsModalLabel">Push Products to Showroom(s)</h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('sync.products') }}" method="POST">
                        @csrf
                        <div class="modal-body py-2 px-3">
                            <div class="mb-2">
                                <label for="apishowroom_ids_products" class="form-label small mb-0">Select Showroom(s):</label>
                                <select class="form-select form-select-sm select2-modal @error('apishowroom_ids') is-invalid @enderror" id="apishowroom_ids_products" name="apishowroom_ids[]" multiple required>
                                    @foreach ($apishowrooms as $apishowroom)
                                        <option value="{{ $apishowroom->id }}">{{ $apishowroom->name }}</option>
                                    @endforeach
                                </select>
                                @error('apishowroom_ids')
                                    <div class="invalid-feedback d-block small">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="modal-footer py-2 px-3">
                            <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-sm btn-warning">Sync Now</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="mt-2 small">
            {{ $products->withQueryString()->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    $('#syncProductsModal').on('shown.bs.modal', function () {
        $('#apishowroom_ids_products').select2({
            theme: 'bootstrap-5',
            dropdownParent: $('#syncProductsModal'),
            width: '100%',
            placeholder: 'Select Showroom(s)',
            allowClear: true
        });
    });

    function exportToExcel() {
        const wb = XLSX.utils.table_to_book(document.getElementById('product-table'));
        XLSX.writeFile(wb, 'Products.xlsx');
    }
</script>
@endpush