@extends('layouts.main')

@section('content')
<div class="container-fluid mt-2">
    @if (session('error'))
        <div class="alert alert-danger alert-sm">{{ session('error') }}</div>
    @endif
    @if (session('warning'))
        <div class="alert alert-warning alert-sm">{{ session('warning') }}</div>
    @endif

    <form method="GET" action="{{ route('apidmysales.index') }}" class="card mb-2">
        <div class="card-header p-1">
            <h5 class="m-0">Search Report</h5>
        </div>
        <div class="card-body p-2">
            <div class="row">
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Showroom</label>
                    <select name="showroom_id" class="form-control form-control-sm select2">
                        <option value="all">All Showrooms</option>
                        @foreach ($showrooms ?? [] as $showroom)
                            <option value="{{ $showroom['id'] }}" {{ old('showroom_id', $filters['showroom_id'] ?? '') == $showroom['id'] ? 'selected' : '' }}>{{ $showroom['name'] }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">From Date</label>
                    <input type="date" name="from_date" class="form-control form-control-sm" value="{{ old('from_date', $filters['from_date'] ?? '') }}">
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">To Date</label>
                    <input type="date" name="to_date" class="form-control form-control-sm" value="{{ old('to_date', $filters['to_date'] ?? '') }}">
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Product Name</label>
                    <select name="productname" class="form-control form-control-sm select2">
                        <option value="">Select Product</option>
                        @foreach ($productNames ?? [] as $name)
                            <option value="{{ $name }}" {{ old('productname', $filters['productname'] ?? '') == $name ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Product Category</label>
                    <select name="productcategory" class="form-control form-control-sm select2">
                        <option value="">Select Category</option>
                        @foreach ($productCategories ?? [] as $category)
                            <option value="{{ $category }}" {{ old('productcategory', $filters['productcategory'] ?? '') == $category ? 'selected' : '' }}>{{ $category }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Production Department</label>
                    <select name="productiondepartment" class="form-control form-control-sm select2">
                        <option value="">Select Department</option>
                        @foreach ($productionDepartments ?? [] as $department)
                            <option value="{{ $department }}" {{ old('productiondepartment', $filters['productiondepartment'] ?? '') == $department ? 'selected' : '' }}>{{ $department }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Barcode</label>
                    <input type="text" name="barcode" class="form-control form-control-sm" value="{{ old('barcode', $filters['barcode'] ?? '') }}">
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">SKU</label>
                    <input type="text" name="sku" class="form-control form-control-sm" value="{{ old('sku', $filters['sku'] ?? '') }}">
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Custom No</label>
                    <input type="text" name="custom_no" class="form-control form-control-sm" value="{{ old('custom_no', $filters['custom_no'] ?? '') }}">
                </div>
            </div>
        </div>
        <div class="card-footer p-1">
            <button type="submit" class="btn btn-primary btn-sm">Search</button>
            <a href="{{ route('apidmysales.create') }}" class="btn btn-secondary btn-sm">Reset</a>
        </div>
    </form>

    <div class="card mb-2">
        <div class="card-header p-1">
            <h5 class="m-0">Sales Report</h5>
        </div>
        <div class="card-body p-2">
            <h6 class="text-center">{{ $report1['heading1'] ?? '' }}</h6>
            <h6 class="text-center">{{ $report1['heading2'] ?? '' }}</h6>
            <table class="table table-bordered table-striped table-hover table-sm">
                <thead>
                    <tr>
                        @foreach ($report1['columns'] ?? [] as $column)
                            <th>{{ $column }}</th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @forelse ($report1['data'] ?? [] as $row)
                        <tr>
                            @foreach ($row as $value)
                                <td>{{ $value }}</td>
                            @endforeach
                        </tr>
                    @empty
                        <tr><td colspan="{{ count($report1['columns'] ?? []) }}">No data available</td></tr>
                    @endforelse
                </tbody>
                <tfoot>
                    <tr>
                        <th>Total</th>
                        <th>{{ $report1['total']['total_sale'] ?? '0.00' }}</th>
                        <th>{{ $report1['total']['total_discount'] ?? '0.00' }}</th>
                        <th>{{ $report1['total']['total_net_sale'] ?? '0.00' }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <div class="card mb-2">
        <div class="card-header p-1">
            <h5 class="m-0">Product-wise Sales Report</h5>
        </div>
        <div class="card-body p-2">
            <h6 class="text-center">{{ $report2['heading1'] ?? '' }}</h6>
            <h6 class="text-center">{{ $report2['heading2'] ?? '' }}</h6>
            <table class="table table-bordered table-striped table-hover table-sm">
                <thead>
                    <tr>
                        @foreach ($report2['columns'] ?? [] as $column)
                            <th>{{ $column }}</th>
                        @endforeach
                    </tr>
                </thead>
                <tbody>
                    @forelse ($report2['data'] ?? [] as $row)
                        <tr>
                            @foreach ($row as $value)
                                <td>{{ $value }}</td>
                            @endforeach
                        </tr>
                    @empty
                        <tr><td colspan="{{ count($report2['columns'] ?? []) }}">No data available</td></tr>
                    @endforelse
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="{{ count($report2['columns'] ?? []) - 1 }}">Total</th>
                        <th>{{ $report2['total']['total_amount'] ?? '0.00' }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>


</div>
@endsection
@push('scripts')
<script>
    $(document).ready(function () {
        $('.select2').select2({
            width: '100%',
            placeholder: 'Select an option',
            allowClear: true
        });
    });
</script>
@endpush
