@extends('layouts.main')

@section('content')
<div class="container-fluid">
    <h5 class="mb-2 text-secondary">Create New Product Price</h5>
    <div class="card card-body p-2">
        <form action="{{ route('product_prices.store') }}" method="POST">
            @csrf
            <div class="row g-2">
                <div class="col-md-6 col-lg-4">
                    <label for="product_id" class="form-label small mb-0">Product <span class="text-danger">*</span></label>
                    <select class="form-select form-select-sm select2 @error('product_id') is-invalid @enderror" id="product_id" name="product_id" required>
                        <option value="">Select Product</option>
                        @foreach ($products as $product)
                            <option value="{{ $product->id }}" {{ old('product_id') == $product->id ? 'selected' : '' }}>
                                {{ $product->productname }}
                            </option>
                        @endforeach
                    </select>
                    @error('product_id')
                        <div class="invalid-feedback d-block">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 col-lg-4">
                    <label for="price" class="form-label small mb-0">Price <span class="text-danger">*</span></label>
                    <input type="number" step="0.01" class="form-control form-control-sm @error('price') is-invalid @enderror" id="price" name="price" value="{{ old('price') }}" required>
                    @error('price')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 col-lg-4">
                    <label for="effective_start_date" class="form-label small mb-0">Effective Start Date <span class="text-danger">*</span></label>
                    <input type="date" class="form-control form-control-sm @error('effective_start_date') is-invalid @enderror" id="effective_start_date" name="effective_start_date" value="{{ old('effective_start_date', now()->format('Y-m-d\TH:i')) }}" required>
                    @error('effective_start_date')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 col-lg-4">
                    <label for="effective_end_date" class="form-label small mb-0">Effective End Date</label>
                    <input type="date" class="form-control form-control-sm @error('effective_end_date') is-invalid @enderror" id="effective_end_date" name="effective_end_date" value="{{ old('effective_end_date') }}">
                    <div class="form-text small">Leave empty for currently active price.</div>
                    @error('effective_end_date')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 col-lg-4">
                    <label for="changed_by_user_id" class="form-label small mb-0">Changed By User</label>
                    <select class="form-select form-select-sm select2 @error('changed_by_user_id') is-invalid @enderror" id="changed_by_user_id" name="changed_by_user_id">
                        <option value="">Select User</option>
                        @foreach ($users as $user)
                            <option value="{{ $user->id }}" {{ old('changed_by_user_id', auth()->id()) == $user->id ? 'selected' : '' }}>
                                {{ $user->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('changed_by_user_id')
                        <div class="invalid-feedback d-block">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 col-lg-4">
                    <label for="reason" class="form-label small mb-0">Reason</label>
                    <input type="text" class="form-control form-control-sm @error('reason') is-invalid @enderror" id="reason" name="reason" value="{{ old('reason') }}">
                    @error('reason')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 col-lg-4">
                    <div class="form-check form-switch mt-4 pt-1">
                        <input class="form-check-input @error('is_showroom_override') is-invalid @enderror" type="checkbox" id="is_showroom_override" name="is_showroom_override" value="1" {{ old('is_showroom_override') ? 'checked' : '' }}>
                        <label class="form-check-label small" for="is_showroom_override">Showroom Override</label>
                        @error('is_showroom_override')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="col-md-6 col-lg-4" id="showroom_id_group" style="{{ old('is_showroom_override') ? '' : 'display:none;' }}">
                    <label for="showroom_id" class="form-label small mb-0">Showroom</label>
                    <select class="form-select form-select-sm select2 @error('showroom_id') is-invalid @enderror" id="showroom_id" name="showroom_id">
                        <option value="">Select Showroom</option>
                        @foreach ($showrooms as $showroom)
                            <option value="{{ $showroom->id }}" {{ old('showroom_id') == $showroom->id ? 'selected' : '' }}>
                                {{ $showroom->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('showroom_id')
                        <div class="invalid-feedback d-block">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-12 text-end mt-3">
                    <button type="submit" class="btn btn-sm btn-primary">Save Price</button>
                    <a href="{{ route('product_prices.index') }}" class="btn btn-sm btn-secondary ms-2">Cancel</a>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: '100%',
            dropdownCssClass: 'select2-dropdown-sm', // Optional: for smaller dropdown
            selectionCssClass: 'select2-selection-sm', // Optional: for smaller selection box
        });

        $('#is_showroom_override').change(function() {
            if (this.checked) {
                $('#showroom_id_group').show();
                $('#showroom_id').prop('required', true); // Make required when checked
            } else {
                $('#showroom_id_group').hide();
                $('#showroom_id').val('').trigger('change').prop('required', false); // Clear and unrequire
            }
        });

        // Trigger on load for old value
        $('#is_showroom_override').trigger('change');
    });
</script>
@endsection