<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Main Layout'); ?></title>

    
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    
    <link href="<?php echo e(asset('dist/css/bootstrap.min.css')); ?>" rel="stylesheet">

    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    
    <link rel="stylesheet" href="<?php echo e(asset('css/print.min.css')); ?>">

    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

    
    
    <link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>">

    <?php echo $__env->yieldContent('styles'); ?> 
</head>
<body class="d-flex flex-column min-vh-100 bg-light"> 

    
    <?php echo $__env->make('layouts.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    
    <main class="flex-grow-1 py-4"> 
        <div class="container-fluid"> 
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

    
    <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


    
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    
    <script src="<?php echo e(asset('dist/js/bootstrap.bundle.min.js')); ?>"></script>

    
    <script src="https://unpkg.com/xlsx/dist/xlsx.full.min.js"></script>

    
    <script src="<?php echo e(asset('js/print.min.js')); ?>"></script>

    
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>




    
    <script src="<?php echo e(asset('js/custom.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('scripts'); ?> 
    
</body>
</html><?php /**PATH /home/jpbspkpq/central.moscowbakers.top/resources/views/layouts/main.blade.php ENDPATH**/ ?>